<?php
/*--------------------------------------------------------------
   Option.php 2021-05-27
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects;

use Gambio\Admin\Modules\Statistics\App\Overview\Model\Collections\OptionTitles;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Option\Id;

interface Option
{
    /**
     * Return ID.
     */
    public function id(): Id;
    
    
    /**
     * Return value.
     */
    public function value();
    
    
    /**
     * Return type.
     */
    public function type(): string;
    
    
    /**
     * Return titles.
     */
    public function titles(): OptionTitles;
}